<?php

namespace agent;

use DateTime;
use SQLite3;

include_once __DIR__ . "/../core/function/handle.php";

class LinkModify
{
    private $db;


    public function __construct($db)
    {
        $this->db = $db;

    }

    public function replaceLink($inData)
    {
        $returnData = [
            'code' => 0,
            'msg' => '友情链接更新成功'
        ];
        //删除所有的友情链接
        $deleteQuery = "DELETE FROM `ay_link`";
        $result = $this->db->exec($deleteQuery);
        if ($result) {
            $returnData['code'] = 1;
        } else {
            $returnData['msg'] = "清除友情链接表失败";
        }
        $dataTime = (new DateTime())->format('Y-m-d H:i:s');
        $data = [];
        foreach ($inData['sites'] as $v) {
            $data[] = [
                'acode' => 'cn',
                'gid' => 1,
                'name' => $v['name'],
                'link' => 'http://' . $v['site_name'],
                'logo' => '',
                'sorting' => 256,
                'create_user' => 'admin',
                'update_user' => 'admin',
                'create_time' => $dataTime,
                'update_time' => $dataTime
            ];
        }


// 构建多行插入的 SQL 语句// 构建插入 SQL
        $values = [];
        foreach ($data as $row) {
            $values[] = sprintf(
                "('%s', %d, '%s', '%s','%s', %d, '%s', '%s', '%s', '%s')",
                SQLite3::escapeString($row['acode']),
                (int)$row['gid'],
                SQLite3::escapeString($row['name']),
                SQLite3::escapeString($row['link']),
                SQLite3::escapeString($row['logo']),
                (int)$row['sorting'],
                SQLite3::escapeString($row['create_user']),
                SQLite3::escapeString($row['update_user']),
                SQLite3::escapeString($row['create_time']),
                SQLite3::escapeString($row['update_time'])
            );
        }

        $sql = "INSERT INTO `ay_link` (acode, gid, name, link,logo, sorting, create_user, update_user, create_time, update_time) VALUES " . implode(", ", $values);

        $result = $this->db->exec($sql);
// 执行插入语句
        if ($result) {
            $returnData['code'] = 1;
        } else {
            $returnData['msg'] = "替换友情链接失败";
        }

        return $returnData;
    }


}