<?php

namespace agent;

include_once __DIR__."/../core/function/handle.php";
class BaseModify
{
    private $db;

    const SITE_COLUMN = [
        'title',
        'description',
        'subtitle',
        'domain',
        'logo',
        'keywords',
        'icp',
        'copyright'
    ];

    const COMPANY_COLUMN = [
        'name',
        'blicense'
    ];

    public function __construct($db){
        $this->db = $db;

    }

    public function changeAdminPwd($data)
    {

        $newPwd = encrypt_string('zq12345688');
        //$newPwd = encrypt_string($data['pwd']);

        $returnData = [
            'code' => 0,
            'msg' => '密码更新成功'
        ];
        $user = 'admin';
        // 查询用户信息
        $query = "SELECT * FROM ay_user WHERE username = :username";
        $stmt = $this->db->prepare($query);
        $stmt->bindValue(':username', $user);

        // 执行查询
        $result = $stmt->execute();
        $user = $result->fetchArray(SQLITE3_ASSOC);

        // 检查用户是否存在
        if ($user) {
//            $updateQuery = "UPDATE ay_user SET password = :pwd WHERE username = :username";
//            $updateStmt = $this->db->prepare($updateQuery);
//            $updateStmt->bindValue(':pwd', $newPwd);
//            $updateStmt->bindValue(':username', $user);
//            // 执行更新操作
//            $updateResult = $updateStmt->execute();
            $updateResult = $this->db->exec("UPDATE ay_user SET realname='超级管理员', password ='".$newPwd."' WHERE username = 'admin'");

            if ($updateResult) {
                $returnData['code'] = 1;
            } else {
                $returnData['msg'] = "默认管理员密码更新失败";
            }
        } else {
            $returnData['msg'] = "默认管理员不存在";
        }
        return $returnData;
    }

    public function changeModifySite(array $data)
    {
        //这里强制将手机站做个性
        $this->db->exec("UPDATE ay_config SET value='".$data['wap_domain']."' WHERE name = 'wap_domain'");

        $returnData = [
            'code' => 0,
            'msg' => ''
        ];
        $updateQuery = "";
        foreach ($data as $key => $value) {
            if (in_array($key, self::SITE_COLUMN)) {
                $updateQuery = $updateQuery . ", `".$key . "`=:" . $key;
            }
        }
        if ($updateQuery == "") {
            $returnData['msg'] = '没有可以更新的数据';
            return $returnData;
        }

        // 检查用户是否存在
        $updateQuery = "UPDATE ay_site SET " . mb_substr($updateQuery,1);
        $updateStmt = $this->db->prepare($updateQuery);
        //$stringReturn='';
        foreach ($data as $key => $value) {
            if (in_array($key, self::SITE_COLUMN)) {
                //$stringReturn=$stringReturn.'//' .$key.'--'.$value;
                $updateStmt->bindValue(':' . $key, $value, SQLITE3_TEXT);
            }
        }
        //return $stringReturn;
        // 执行更新操作
        $updateResult = $updateStmt->execute();
        if ($updateResult) {
            $returnData['code'] = 1;
        } else {
            $returnData['msg'] = "更新网站配置失败";
        }
        return $returnData;
    }

    public function addConfig(array $data)
    {

        //$newPwd = encrypt_string($data['pwd']);

        $returnData = [
            'code' => 0,
            'msg' => '密码更新成功'
        ];
        $configData=[
            'title_province'=>$data['title_province'],
            'title_city'=>$data['title_city'],
            'keywords_province'=>$data['keywords_province'],
            'keywords_city'=>$data['keywords_city'],
            'description_province'=>$data['description_province'],
            'description_city'=>$data['description_city']
        ];
        foreach ($configData as $key=>$nowData){
            // 获得数据
            // 查询用户信息
            $query = "SELECT * FROM ay_config WHERE name = :key";
            $stmt = $this->db->prepare($query);
            $stmt->bindValue(':key', $key);
            // 执行查询
            $result = $stmt->execute();
            $qResult = $result->fetchArray(SQLITE3_ASSOC);
            // 如果存在，那么直接更新
            if ($qResult) {
                $updateResult = $this->db->exec("UPDATE ay_config SET value='".$nowData."' WHERE name = '".$key."'");
                if ($updateResult) {
                    $returnData['code'] = 1;
                } else {
                    $returnData['msg'] = "默认管理员密码更新失败";
                }
            } else {
               //如果没有插入一个新数据
                $insertResult = $this->db->exec("INSERT INTO ay_config (name,value,type,sorting,description) VALUES ('".$key."','".$nowData."',2,255,'关键词配置')");
                if ($insertResult) {
                    $returnData['code'] = 1;
                } else {
                    $returnData['msg'] = "增加配置失败";
                }
            }
        }



        return $returnData;
    }

    public function changeCompany(array $data)
    {
        $returnData = [
            'code' => 0,
            'msg' => ''
        ];
        $updateQuery = "";
        foreach ($data as $key => $value) {
            if (in_array($key, self::COMPANY_COLUMN)) {
                $updateQuery = $updateQuery . ", `".$key . "`=:" . $key;
            }
        }
        if ($updateQuery == "") {
            $returnData['msg'] = '没有可以更新的数据';
            return $returnData;
        }

        // 检查用户是否存在
        $updateQuery = "UPDATE ay_company SET " . mb_substr($updateQuery,1);
        $updateStmt = $this->db->prepare($updateQuery);
        //$stringReturn='';
        foreach ($data as $key => $value) {
            if (in_array($key, self::COMPANY_COLUMN)) {
                //$stringReturn=$stringReturn.'//' .$key.'--'.$value;
                $updateStmt->bindValue(':' . $key, $value, SQLITE3_TEXT);
            }
        }
        //return $stringReturn;
        // 执行更新操作
        $updateResult = $updateStmt->execute();

        if ($updateResult) {
            $returnData['code'] = 1;
        } else {
            $returnData['msg'] = "更新公司信息失败";
        }
        return $returnData;
    }

}