<?php

namespace agent;

use DateTime;
use SQLite3;

include_once __DIR__ . "/../core/function/handle.php";

class ArticleModify
{
    private $db;


    public function __construct($db)
    {
        $this->db = $db;

    }

    public function AddArticle($inData)
    {
        $returnData = [
            'code' => 0,
            'msg' => '新增文章成功'
        ];
        //查询文章类型的信息
        //优先查新闻动态的
        $newQuery="SELECT * FROM ay_content_sort WHERE `listtpl` ='newslist.html' AND `contenttpl` ='news.html' AND `name`='新闻动态'";
        $newQueryResult = $this->db->query($newQuery);
        if ($newQueryResult) {
            $newQueryResult = $newQueryResult->fetchArray(SQLITE3_ASSOC);
            if (!$newQueryResult) {
                $query = "SELECT * FROM ay_content_sort WHERE `listtpl` ='newslist.html' AND `contenttpl` ='news.html'";
                $result = $this->db->query($query);
                $result = $result->fetchArray(SQLITE3_ASSOC);
            }else{
                $result=$newQueryResult;
            }
        }else{
            $query = "SELECT * FROM ay_content_sort WHERE `listtpl` ='newslist.html' AND `contenttpl` ='news.html'";
            $result = $this->db->query($query);
            if (!$result) {
                $returnData['msg'] = '没有找到文章类型的分类';
                return $returnData;
            }
            $result = $result->fetchArray(SQLITE3_ASSOC);
        }
        if ($result == false) {
            $returnData['msg'] = '没有找到文章类型的分类的结果';
            return $returnData;
        }
        //这里再找一下，上面的一级没有子级，如果有子级，就使用子级的来做背景版
        $childQuery = "SELECT * FROM ay_content_sort WHERE `pcode` ='" . $result['scode'] . "'";
        $childQueryResult = $this->db->query($childQuery);
        $childQueryResult = $childQueryResult->fetchArray(SQLITE3_ASSOC);
        if ($childQueryResult != false) {
            $articleQuery = "SELECT * FROM ay_content WHERE `scode` ='" . $childQueryResult['scode'] . "'";
        } else {
            //查找一条已经存在的文章做模板
            $articleQuery = "SELECT * FROM ay_content WHERE `scode` ='" . $result['scode'] . "'";
        }
        $queryArticleResult = $this->db->query($articleQuery);
        //循环这个例子数据，只替换里面的title,date,content,description
        //去掉ID
        $articleResult = $queryArticleResult->fetchArray(SQLITE3_ASSOC);
        if (!is_array($articleResult)) {
            //因为没有例句，所以直接从表里拿一条数据来充数
            $uniOneQuery = "SELECT * FROM ay_content";
            $uniOneQueryResult = $this->db->query($uniOneQuery);
            $articleResult = $uniOneQueryResult->fetchArray(SQLITE3_ASSOC);
            //如果还是没有数据，不做处理
            if ($articleResult == false) {
                $returnData['msg'] = "基础文章不存在，不做处理";
                return $returnData;
            }
            $articleResult['scode'] = $result['scode'];
            $articleResult['acode'] = $result['acode'];
        }
        unset($articleResult['id']);
        $articleResult['title'] = $inData['title'];
        $articleResult['content'] = $inData['content'];
        $articleResult['date'] = (new DateTime())->format('Y-m-d H:i:s');
        $articleResult['description'] = $inData['description'];
        $articleResult['tags']=$inData['tags'];
        $articleResult['keywords']=$inData['keywords'];
        if($inData['ico']!==''){
            $articleResult['ico']=$inData['ico'];
        }
// 动态生成字段名和占位符
        $columns = array_keys($articleResult); // 获取字段名
        $placeholders = array_map(function ($col) {
            return ":$col";
        }, $columns); // 生成占位符

// 准备 SQL 语句
        $sql = 'INSERT INTO ay_content (' . implode(', ', $columns) . ') VALUES (' . implode(', ', $placeholders) . ')';
// 准备插入语句
        $stmt = $this->db->prepare($sql);

// 动态绑定数据，根据值的类型选择正确的绑定类型
        foreach ($articleResult as $key => $value) {
            if (is_int($value)) {
                $stmt->bindValue(":$key", $value, SQLITE3_INTEGER); // 整数
            } elseif (is_float($value)) {
                $stmt->bindValue(":$key", $value, SQLITE3_FLOAT); // 浮点数
            } elseif (is_string($value)) {
                $stmt->bindValue(":$key", $value, SQLITE3_TEXT); // 字符串
            } elseif (is_null($value)) {
                $stmt->bindValue(":$key", $value, SQLITE3_NULL); // NULL 值
            } else {
                // 其他类型的处理，可以选择 BLOB 或其他合适的类型
                $stmt->bindValue(":$key", $value, SQLITE3_BLOB);
            }
        }
// 执行插入操作
        $handResult = $stmt->execute();
        if ($handResult) {
            $returnData['code'] = 1;
        } else {
            $returnData['msg'] = "新增文章失败";
        }

        return $returnData;
    }

    public function modifyArticle($inData)
    {
        $returnData = [
            'code' => 0,
            'msg' => '修改文章成功'
        ];
        $updateResult = $this->db->exec("UPDATE ay_content SET description=title WHERE id>540 ");

        if ($updateResult) {
            $returnData['code'] = 1;
        } else {
            $returnData['msg'] = "修改文章失败";
        }

        return $returnData;
    }


}