<?php

namespace agent;

use SQLite3;

include_once __DIR__."/../core/function/file.php";
include_once __DIR__."/../core/function/handle.php";
include_once "BaseModify.php";
include_once "LinkModify.php";
include_once "ArticleModify.php";
class AgentPost
{

    public $data = [];

    public $db;

    private $rootPath;



    public function __construct($postData, SQLite3 $db,$rootPath)
    {
        $this->data = $postData;
        $this->db = $db;
        $this->rootPath = $rootPath;
    }


    private function checkTable(string $tableName)
    {
        $returnData = [
            'code' => 0,
            'msg' => ''
        ];
        // 检查表是否存在
        $checkTableQuery = "SELECT name FROM sqlite_master WHERE type='table' AND name=:tableName";
        $checkStmt = $this->db->prepare($checkTableQuery);
        $checkStmt->bindValue(':tableName', $tableName, SQLITE3_TEXT);

        $tableResult = $checkStmt->execute();
        $tableExists = $tableResult->fetchArray(SQLITE3_ASSOC);
        if (!$tableExists) {
            $returnData['msg'] = $tableExists;
        }else{
            $returnData['code'] = 1;
        }
        return $returnData;
    }

    public function handleData()
    {
        $returnResult = [
            'code' => 1,
            'msg' => ''
        ];

        switch ($this->data['type']) {
            //修改授权码
            case 'sign':
                $result = $this->checkTable('ay_config');
                if ($result['code'] != 1) {
                    return $result;
                }
                $returnResult = $this->signSite($this->data);
                //修改默认密码
                break;
            //修改默认密码
            case 'pwd':
                $result = $this->checkTable('ay_user');
                if ($result['code'] != 1) {
                    return $returnResult;
                }
                $baseModify = new BaseModify($this->db);
                $returnResult = $baseModify->changeAdminPwd($this->data);
                break;
            //修改默认版权//修改logo//修改标题//修改主域//修改子标题//修改关键词//修改描述//修改icp
            case 'copyright':
                $result = $this->checkTable('ay_site');
                if ($result['code'] != 1) {
                    return $returnResult;
                }
                $baseModify = new BaseModify($this->db);
                $returnResult = $baseModify->changeModifySite($this->data);
                path_delete($this->rootPath.'/runtime/cache');
                path_delete($this->rootPath.'/runtime/config');
                path_delete($this->rootPath.'/runtime/complile');
                path_delete($this->rootPath.'/runtime/session');
                break;
            //添加标题//添加关键词//添加描述的替换
            case 'add_config':
                $result = $this->checkTable('ay_config');
                if ($result['code'] != 1) {
                    return $returnResult;
                }
                $baseModify = new BaseModify($this->db);
                $returnResult = $baseModify->addConfig($this->data);
                path_delete($this->rootPath.'/runtime/cache');
                path_delete($this->rootPath.'/runtime/config');
                path_delete($this->rootPath.'/runtime/complile');
                path_delete($this->rootPath.'/runtime/session');
                break;
            //修改默认版权//修改logo//修改标题//修改主域//修改子标题//修改关键词//修改描述//修改icp
            case 'company':
                $result = $this->checkTable('ay_company');
                if ($result['code'] != 1) {
                    return $returnResult;
                }
                $baseModify = new BaseModify($this->db);
                $returnResult = $baseModify->changeCompany($this->data);
                path_delete($this->rootPath.'/runtime/cache');
                path_delete($this->rootPath.'/runtime/config');
                path_delete($this->rootPath.'/runtime/complile');
                path_delete($this->rootPath.'/runtime/session');
                break;
            //友情链接处理
            case 'link':
                $result = $this->checkTable('ay_link');
                if ($result['code'] != 1) {
                    return $returnResult;
                }
                $linkModify=new LinkModify($this->db);
                $returnResult=$linkModify->replaceLink($this->data);
                path_delete($this->rootPath.'/runtime/cache');
                path_delete($this->rootPath.'/runtime/config');
                path_delete($this->rootPath.'/runtime/complile');
                path_delete($this->rootPath.'/runtime/session');
                break;
            case 'article':
                $result = $this->checkTable('ay_content_sort');
                if ($result['code'] != 1) {
                    return $returnResult;
                }$result = $this->checkTable('ay_content');
                if ($result['code'] != 1) {
                    return $returnResult;
                }
                $articleModify=new ArticleModify($this->db);
                $returnResult=$articleModify->AddArticle($this->data);
                path_delete($this->rootPath.'/runtime/cache');
                path_delete($this->rootPath.'/runtime/config');
                path_delete($this->rootPath.'/runtime/complile');
                path_delete($this->rootPath.'/runtime/session');
                break;
            case 'modify_article':
                $result = $this->checkTable('ay_content_sort');
                if ($result['code'] != 1) {
                    return $returnResult;
                }$result = $this->checkTable('ay_content');
                if ($result['code'] != 1) {
                    return $returnResult;
                }
                $articleModify=new ArticleModify($this->db);
                $returnResult=$articleModify->modifyArticle($this->data);
                path_delete($this->rootPath.'/runtime/cache');
                path_delete($this->rootPath.'/runtime/config');
                path_delete($this->rootPath.'/runtime/complile');
                path_delete($this->rootPath.'/runtime/session');
                break;
            default:
        }

        return $returnResult;
    }






    private function modifyLink(array $data)
    {

        $returnData = [
            'code' => 0,
            'msg' => '待实现'
        ];
//        $updateQuery = "";
//
//        foreach ($data as $key => $value) {
//            if (in_array($key, self::SITE_COLUMN)) {
//                $updateQuery = $updateQuery . $key . "=:" . $key;
//            }
//        }
//        if ($updateQuery == "") {
//            $returnData['msg'] = '没有可以更新的数据';
//            return $returnData;
//        }
//
//        // 检查用户是否存在
//        $updateQuery = "UPDATE ay_site SET " . $updateQuery;
//        $updateStmt = $this->db->prepare($updateQuery);
//        foreach ($data as $key => $value) {
//            if (in_array($key, self::SITE_COLUMN)) {
//                $updateStmt->bindValue(':' . $key, $value);
//            }
//        }
//        // 执行更新操作
//        $updateResult = $updateStmt->execute();
//        if ($updateResult) {
//            $returnData['code'] = 1;
//        } else {
//            $returnData['msg'] = "更新网站配置失败";
//        }
        return $returnData;
    }

    private function signSite(array $data)
    {

        //更新M站点
        $returnData = $this->updateConfig('wap_domain', $data['wap']);
        if ($returnData['code'] != 1) {
            return $returnData;
        }
        $returnData = $this->updateConfig('sn', $data['sn']);
        if ($returnData['code'] != 1) {
            return $returnData;
        }
        $returnData = $this->updateConfig('sn_user', $data['sn_user']);
        if ($returnData['code'] != 1) {
            return $returnData;
        }

        //进行程序的授权操作

        $data['licensecode'] = base64_encode($data['sn']. '/' . $data['sn_user']) . substr($data['sn'], 1, 1);
        $returnData=$this->updateConfig('licensecode', $data['licensecode']);
        if ($returnData['code'] != 1) {
            return $returnData;
        }

        $result=path_delete($this->rootPath.'/runtime/config'); // 清理缓存的配置文件
        if(!$result){
            return [
                'code' => 0,
                'msg'=>'清掉缓冲失败'
            ];
        }else{
            return [
                'code' => 1,
                'msg'=>'成功'
            ];
        }
    }

    private function updateConfig($key, $value)
    {
        $returnData = [
            'code' => 1,
            'msg' => ''
        ];
        // 查询用户信息
        $query = "SELECT * FROM ay_config WHERE name = :name";
        $stmt = $this->db->prepare($query);
        $stmt->bindValue(':name', $key);

        // 执行查询
        $result = $stmt->execute();
        $sn = $result->fetchArray(SQLITE3_ASSOC);

        // 检查用户是否存在
        if ($sn) {
            $updateQuery = "UPDATE ay_config SET value = :value WHERE name = :name";
            $updateStmt = $this->db->prepare($updateQuery);
            $updateStmt->bindValue(':value', $value);
            $updateStmt->bindValue(':name', $key);

            // 执行更新操作
            $updateResult = $updateStmt->execute();

            if ($updateResult) {
                $returnData['code'] = 1;
            } else {
                $returnData['code'] = 0;
                $returnData['msg'] = "修改授权信息失败";
            }
        }
        return $returnData;
    }


}