<?php

use agent\AgentPost;

require_once "agent/AgentPost.php";
// 设置响应头为 JSON 格式
header('Content-Type: application/json');

// 获取请求方法
$requestMethod = $_SERVER['REQUEST_METHOD'];

// 初始化响应数组
$response = [
    'success' => false,
    'message' => '',
    'data' => null
];

$config = include("./config/database.php");
// SQLite 数据库文件路径
$dbFile = $config['database']['dbname'];
//配置数据库表的实际路径
$dbFile=__DIR__.$dbFile;
// 创建 SQLite3 数据库连接
try {
    $db = new SQLite3($dbFile);
} catch (Exception $e) {
    die("无法连接数据库: " . $e->getMessage());
}

$rootPath = __DIR__;

switch ($requestMethod) {
    case 'GET':
        // 处理 GET 请求
        // 获取查询参数
        $name = $_GET['name'] ?? 'Guest';
        $response['success'] = true;
        $response['message'] = "Hello, $name!";
        break;

    case 'POST':
        // 处理 POST 请求
        // 获取 POST 数据
        $data = json_decode(file_get_contents('php://input'), true);
        $agPost = new AgentPost($data, $db,$rootPath);
        $response = $agPost->handleData();
        break;
    default:
        // 不支持的方法
        $response['message'] = "Unsupported request method: $requestMethod.";
        break;
}
$db->close();
echo json_encode($response);
